"""
This file holds all URLs and reference scores.
"""

DATASET_URLS = {# bullet_safety_gym
                "AntCircle": "http://data.offline-saferl.org/download/SafetyAntCircle-v0-200-5728.hdf5",
                "AntRun": "http://data.offline-saferl.org/download/SafetyAntRun-v0-150-1816.hdf5",
                "BallCircle": "http://data.offline-saferl.org/download/SafetyBallCircle-v0-80-886.hdf5",
                "BallRun": "http://data.offline-saferl.org/download/SafetyBallRun-v0-80-940.hdf5",
                "CarCircle": "http://data.offline-saferl.org/download/SafetyCarCircle-v0-100-1450.hdf5",
                "CarRun": "http://data.offline-saferl.org/download/SafetyCarRun-v0-40-651.hdf5",
                "DroneCircle": "http://data.offline-saferl.org/download/SafetyDroneCircle-v0-100-1923.hdf5",
                "DroneRun": "http://data.offline-saferl.org/download/SafetyDroneRun-v0-140-1990.hdf5",
                # safety_gymnasium: Car
                "CarButton1": "http://data.offline-saferl.org/download/SafetyCarButton1Gymnasium-v0-250-2656.hdf5",
                "CarButton2": "http://data.offline-saferl.org/download/SafetyCarButton2Gymnasium-v0-300-3755.hdf5",
                "CarCircle1": "http://data.offline-saferl.org/download/SafetyCarCircle1Gymnasium-v0-250-1271.hdf5",
                "CarCircle2": "http://data.offline-saferl.org/download/SafetyCarCircle2Gymnasium-v0-400-940.hdf5",
                "CarGoal1": "http://data.offline-saferl.org/download/SafetyCarGoal1Gymnasium-v0-120-1671.hdf5",
                "CarGoal2": "http://data.offline-saferl.org/download/SafetyCarGoal2Gymnasium-v0-200-4105.hdf5",
                "CarPush1": "http://data.offline-saferl.org/download/SafetyCarPush1Gymnasium-v0-200-2871.hdf5",
                "CarPush2": "http://data.offline-saferl.org/download/SafetyCarPush2Gymnasium-v0-250-4407.hdf5",
                # safety_gymnasium: Point
                "PointButton1": "http://data.offline-saferl.org/download/SafetyPointButton1Gymnasium-v0-200-2268.hdf5",
                "PointButton2": "http://data.offline-saferl.org/download/SafetyPointButton2Gymnasium-v0-250-3288.hdf5",                
                "PointCircle1": "http://data.offline-saferl.org/download/SafetyPointCircle1Gymnasium-v0-200-1098.hdf5",
                "PointCircle2": "http://data.offline-saferl.org/download/SafetyPointCircle2Gymnasium-v0-300-895.hdf5",
                "PointGoal1": "http://data.offline-saferl.org/download/SafetyPointGoal1Gymnasium-v0-100-2022.hdf5",
                "PointGoal2": "http://data.offline-saferl.org/download/SafetyPointGoal2Gymnasium-v0-200-3442.hdf5",
                "PointPush1": "http://data.offline-saferl.org/download/SafetyPointPush1Gymnasium-v0-150-2379.hdf5",
                "PointPush2": "http://data.offline-saferl.org/download/SafetyPointPush2Gymnasium-v0-200-3242.hdf5",
                # safety_gymnasium: velocity
                "AntCircle_V1": "http://data.offline-saferl.org/download/SafetyAntCircleGymnasium-v1-250-2249.hdf5",
                "AntVelocity": "http://data.offline-saferl.org/download/SafetyAntVelocityGymnasium-v1-250-2249.hdf5",
                "HalfCheetahVelocity": "http://data.offline-saferl.org/download/SafetyHalfCheetahVelocityGymnasium-v1-250-2495.hdf5",
                "HopperVelocity": "http://data.offline-saferl.org/download/SafetyHopperVelocityGymnasium-v1-250-2240.hdf5",
                "SwimmerVelocity": "http://data.offline-saferl.org/download/SafetySwimmerVelocityGymnasium-v1-200-1686.hdf5",
                "Walker2dVelocity": "http://data.offline-saferl.org/download/SafetyWalker2dVelocityGymnasium-v1-300-2729.hdf5",
                "AntVelocity_V0": "http://data.offline-saferl.org/download/SafetyAntVelocityGymnasium-v0-250-2249.hdf5",
                "HalfCheetahVelocity_V0": "http://data.offline-saferl.org/download/SafetyHalfCheetahVelocityGymnasium-v0-250-2495.hdf5",
                "HopperVelocity_V0": "http://data.offline-saferl.org/download/SafetyHopperVelocityGymnasium-v0-250-2240.hdf5",
                "SwimmerVelocity_V0": "http://data.offline-saferl.org/download/SafetySwimmerVelocityGymnasium-v0-200-1686.hdf5",
                "Walker2dVelocity_V0": "http://data.offline-saferl.org/download/SafetyWalker2dVelocityGymnasium-v0-300-2729.hdf5",
                "AntVelocity_V2": "http://data.offline-saferl.org/download/SafetyAntVelocityGymnasium-v2-250-2249.hdf5",
                "HalfCheetahVelocity_V2": "http://data.offline-saferl.org/download/SafetyHalfCheetahVelocityGymnasium-v2-250-2495.hdf5",
                "HopperVelocity_V2": "http://data.offline-saferl.org/download/SafetyHopperVelocityGymnasium-v2-250-2240.hdf5",
                "HopperVelocity_V3": "http://data.offline-saferl.org/download/SafetyHopperVelocityGymnasium-v3-250-2240.hdf5",
                "HopperVelocity_V4": "http://data.offline-saferl.org/download/SafetyHopperVelocityGymnasium-v4-250-2240.hdf5",
                "HopperVelocity_V5": "http://data.offline-saferl.org/download/SafetyHopperVelocityGymnasium-v5-250-2240.hdf5",
                "HopperVelocity_V6": "http://data.offline-saferl.org/download/SafetyHopperVelocityGymnasium-v6-250-2240.hdf5",
                "HopperVelocity_V7": "http://data.offline-saferl.org/download/SafetyHopperVelocityGymnasium-v7-250-2240.hdf5",
                "SwimmerVelocity_V2": "http://data.offline-saferl.org/download/SafetySwimmerVelocityGymnasium-v2-200-1686.hdf5",
                "Walker2dVelocity_V2": "http://data.offline-saferl.org/download/SafetyWalker2dVelocityGymnasium-v2-300-2729.hdf5",
                "AntVelocity_V3": "http://data.offline-saferl.org/download/SafetyAntVelocityGymnasium-v3-250-2249.hdf5",
                "AntVelocity_V4": "http://data.offline-saferl.org/download/SafetyAntVelocityGymnasium-v4-250-2249.hdf5",
                "AntVelocity_V5": "http://data.offline-saferl.org/download/SafetyAntVelocityGymnasium-v5-250-2249.hdf5",
                "AntVelocity_V6": "http://data.offline-saferl.org/download/SafetyAntVelocityGymnasium-v6-250-2249.hdf5",
                "AntVelocity_V7": "http://data.offline-saferl.org/download/SafetyAntVelocityGymnasium-v7-250-2249.hdf5",
                # safe_metadrive
                "easysparse": "http://data.offline-saferl.org/download/SafeMetaDrive-easysparse-v0-85-1000.hdf5",
                "easymean": "http://data.offline-saferl.org/download/SafeMetaDrive-easymean-v0-85-1000.hdf5",
                "easydense": "http://data.offline-saferl.org/download/SafeMetaDrive-easydense-v0-85-1000.hdf5",
                "mediumsparse": "http://data.offline-saferl.org/download/SafeMetaDrive-mediumsparse-v0-50-1000.hdf5",
                "mediummean": "http://data.offline-saferl.org/download/SafeMetaDrive-mediummean-v0-50-1000.hdf5",
                "mediumdense": "http://data.offline-saferl.org/download/SafeMetaDrive-mediumdense-v0-50-1000.hdf5",
                "hardsparse": "http://data.offline-saferl.org/download/SafeMetaDrive-hardsparse-v0-85-1000.hdf5",
                "hardmean": "http://data.offline-saferl.org/download/SafeMetaDrive-hardmean-v0-85-1000.hdf5",
                "harddense": "http://data.offline-saferl.org/download/SafeMetaDrive-harddense-v0-85-1000.hdf5"}

DEFAULT_REWARD_THRESHOLD = {"AntVelocity": 6000.0,
                            "HalfCheetahVelocity": 4800.0,
                            "HopperVelocity": 3800.0,
                            "SwimmerVelocity": 360.0,
                            "Walker2dVelocity": None,
                            "AntVelocity_V0": 6000.0,
                            "AntCircle_V1": 6000.0,
                            "HalfCheetahVelocity_V0": 4800.0,
                            "HopperVelocity_V0": 3800.0,
                            "SwimmerVelocity_V0": 360.0,
                            "Walker2dVelocity_V0": None,
                            "AntVelocity_V2": 6000.0,
                            "AntVelocity_V3": 6000.0,
                            "AntVelocity_V4": 6000.0,
                            "AntVelocity_V5": 6000.0,
                            "AntVelocity_V6": 6000.0,
                            "AntVelocity_V7": 6000.0,
                            "HalfCheetahVelocity_V2": 4800.0,
                            "HopperVelocity_V2": 3800.0,
                            "HopperVelocity_V3": 3800.0,
                            "HopperVelocity_V4": 3800.0,
                            "HopperVelocity_V5": 3800.0,
                            "HopperVelocity_V6": 3800.0,
                            "HopperVelocity_V7": 3800.0,
                            "SwimmerVelocity_V2": 360.0,
                            "Walker2dVelocity_V2": None}

DEFAULT_MAX_EPISODE_STEPS = {# bullet_safety_gym
                             "AntCircle": 500,
                             "AntRun": 200,
                             "BallCircle": 200,
                             "BallRun": 100,
                             "CarCircle": 300,
                             "CarRun": 200,
                             "DroneCircle": 300,
                             "DroneRun": 200,
                             # safety_gymnasium
                             "CarButton1": 1000,
                             "CarButton2": 1000,
                             "CarCircle1": 500,
                             "CarCircle2": 500,
                             "CarGoal1": 1000,
                             "CarGoal2": 1000,
                             "CarPush1": 1000,
                             "CarPush2": 1000,
                             "PointButton1": 1000,
                             "PointButton2": 1000,
                             "PointCircle1": 500,
                             "PointCircle2": 500,
                             "PointGoal1": 1000,
                             "PointGoal2": 1000,
                             "PointPush1": 1000,
                             "PointPush2": 1000,
                             "AntVelocity": 1000,
                             "HalfCheetahVelocity": 1000,
                             "HopperVelocity": 1000,
                             "SwimmerVelocity": 1000,
                             "Walker2dVelocity": 1000,
                             "AntVelocity_V0": 1000,
                             "AntCircle_V1": 1000,
                             "HalfCheetahVelocity_V0": 1000,
                             "HopperVelocity_V0": 1000,
                             "SwimmerVelocity_V0": 1000,
                             "Walker2dVelocity_V0": 1000,
                             "AntVelocity_V2": 1000,
                             "AntVelocity_V3": 1000,
                             "AntVelocity_V4": 1000,
                             "AntVelocity_V5": 1000,
                             "AntVelocity_V6": 1000,
                             "AntVelocity_V7": 1000,
                             "HalfCheetahVelocity_V2": 1000,
                             "HopperVelocity_V2": 1000,
                             "HopperVelocity_V3": 1000,
                             "HopperVelocity_V4": 1000,
                             "HopperVelocity_V5": 1000,
                             "HopperVelocity_V6": 1000,
                             "HopperVelocity_V7": 1000,
                             "SwimmerVelocity_V2": 1000,
                             "Walker2dVelocity_V2": 1000,
                             # safe_metadrive
                             "easysparse": 1000,
                             "easymean": 1000,
                             "easydense": 1000,
                             "mediumsparse": 1000,
                             "mediummean": 1000,
                             "mediumdense": 1000,
                             "hardsparse": 1000,
                             "hardmean": 1000,
                             "harddense": 1000}

MAX_EPISODE_REWARD = {# bullet_safety_gym
                      "AntCircle": 460.7091979980469,
                      "AntRun": 955.4818725585938, 
                      "BallCircle": 881.46337890625,
                      "BallRun": 1327.445556640625,
                      "CarCircle": 534.3060913085938, 
                      "CarRun": 574.6533203125, 
                      "DroneCircle": 996.38916015625, 
                      "DroneRun": 682.8330078125,
                      # safety_gymnasium
                      "CarButton1": 44.420003345738984,
                      "CarButton2": 41.99513815522894,
                      "CarCircle1": 24.94155502319336,
                      "CarCircle2": 25.950098037719727,
                      "CarGoal1": 39.907809198384705,
                      "CarGoal2": 28.902897990056502,
                      "CarPush1": 16.304467598905237,
                      "CarPush2": 15.141648491514314,
                      "PointButton1": 41.19301568767707,
                      "PointButton2": 42.8985953616709,
                      "PointCircle1": 61.72819519042969,
                      "PointCircle2": 54.02184295654297,
                      "PointGoal1": 30.071114857340543,
                      "PointGoal2": 27.717709787852737,
                      "PointPush1": 16.518654299293367,
                      "PointPush2": 14.691039145644403,
                      "AntVelocity": 2976.276611328125,
                      "HalfCheetahVelocity": 2806.93310546875,
                      "HopperVelocity": 1911.396728515625,
                      "SwimmerVelocity": 238.95831298828125,
                      "Walker2dVelocity": 3418.223876953125,
                      "AntVelocity_V0": 3179.713623046875,
                      "AntCircle_V1": 3179.713623046875,
                      "HalfCheetahVelocity_V0": 2468.611572265625,
                      "HopperVelocity_V0": 1425.7137451171875,
                      "SwimmerVelocity_V0": 198.21702575683594,
                      "Walker2dVelocity_V0": 1788.52978515625,
                      "AntVelocity_V2": 3192.765869140625,
                      "AntVelocity_V3": 3192.765869140625,
                      "AntVelocity_V4": 3192.765869140625,
                      "AntVelocity_V5": 3192.765869140625,
                      "AntVelocity_V6": 3192.765869140625,
                      "AntVelocity_V7": 3192.765869140625,
                      "HalfCheetahVelocity_V2": 2625.41162109375,
                      "HopperVelocity_V2": 1567.8525390625,
                      "HopperVelocity_V3": 1567.8525390625,
                      "HopperVelocity_V4": 1567.8525390625,
                      "HopperVelocity_V5": 1567.8525390625,
                      "HopperVelocity_V6": 1567.8525390625,
                      "HopperVelocity_V7": 1567.8525390625,
                      "SwimmerVelocity_V2": 127.62435150146484,
                      "Walker2dVelocity_V2": 3046.3486328125,
                      # safe_metadrive
                      "easysparse": 425.8006286621094,
                      "easymean": 425.82440185546875,
                      "easydense": 425.81732177734375,
                      "mediumsparse": 269.80084228515625,
                      "mediummean": 269.8221435546875,
                      "mediumdense": 269.7813415527344,
                      "hardsparse": 486.80523681640625,
                      "hardmean": 486.9967956542969,
                      "harddense": 486.63616943359375}

MIN_EPISODE_REWARD = {# bullet_safety_gym
                      "AntCircle": 0.0177031010389328,
                      "AntRun": 0.001767391717990563, 
                      "BallCircle": 0.38312244415283203,
                      "BallRun": 26.339754104614258,
                      "CarCircle": 3.484419822692871, 
                      "CarRun": 204.28726196289062, 
                      "DroneCircle": 207.794189453125, 
                      "DroneRun": 10.557029724121094,
                      # safety_gymnasium
                      "CarButton1": 0.0028926206826067613,
                      "CarButton2": 0.001767391717990563,
                      "CarCircle1": 8.037073135375977,
                      "CarCircle2": 5.113386154174805,
                      "CarGoal1": 0.012232819540852091,
                      "CarGoal2": 0.001032874531954775,
                      "CarPush1": 0.013700173533941762,
                      "CarPush2": 0.00029391133526335267,
                      "PointButton1": 0.008822109034937853,
                      "PointButton2": 0.014114166087574098,
                      "PointCircle1": 20.067626953125,
                      "PointCircle2": 20.478347778320312,
                      "PointGoal1": 0.01196012764197707,
                      "PointGoal2": 0.002616959830266108,
                      "PointPush1": 0.0014001545292344209,
                      "PointPush2": 0.0012438183001730607,
                      "AntVelocity": 6.1519012451171875,
                      "HalfCheetahVelocity": 5.7509765625,
                      "HopperVelocity": 37.05154800415039,
                      "SwimmerVelocity": 0.07114458084106445,
                      "Walker2dVelocity": 18.668498992919922,
                      "AntVelocity_V0": 0.25980186462402344,
                      "AntCircle_V1": 0.25980186462402344,
                      "HalfCheetahVelocity_V0": 2.0996856689453125,
                      "HopperVelocity_V0": 38.833675384521484,
                      "SwimmerVelocity_V0": 0.24378013610839844,
                      "Walker2dVelocity_V0": 8.848360061645508,
                      "AntVelocity_V2": 10.623882293701172,
                      "AntVelocity_V3": 10.623882293701172,
                      "AntVelocity_V4": 10.623882293701172,
                      "AntVelocity_V5": 10.623882293701172,
                      "AntVelocity_V6": 10.623882293701172,
                      "AntVelocity_V7": 10.623882293701172,
                      "HalfCheetahVelocity_V2": 12.07342529296875,
                      "HopperVelocity_V2": 77.31812286376953,
                      "HopperVelocity_V3": 77.31812286376953,
                      "HopperVelocity_V4": 77.31812286376953,
                      "HopperVelocity_V5": 77.31812286376953,
                      "HopperVelocity_V6": 77.31812286376953,
                      "HopperVelocity_V7": 77.31812286376953,
                      "SwimmerVelocity_V2": 0.1019294261932373,
                      "Walker2dVelocity_V2": 116.26217651367188,
                      # safe_metadrive
                      "easysparse": 20.094310760498047,
                      "easymean": 22.142553329467773,
                      "easydense": 19.71139144897461,
                      "mediumsparse": 17.446578979492188,
                      "mediummean": 17.032529830932617,
                      "mediumdense": 15.102348327636719,
                      "hardsparse": 17.247974395751953,
                      "hardmean": 19.387981414794922,
                      "harddense": 15.386894226074219}

MAX_EPISODE_COST = {# bullet_safety_gym
                    "AntCircle": 200.0,
                    "AntRun": 150.0, 
                    "BallCircle": 80.0,
                    "BallRun": 80.0,
                    "CarCircle": 100.0, 
                    "CarRun": 40.0, 
                    "DroneCircle": 100.0, 
                    "DroneRun": 140.0,
                    # safety_gymnasium
                    "CarButton1": 250.0,
                    "CarButton2": 300.0,
                    "CarCircle1": 250.0,
                    "CarCircle2": 398.0,
                    "CarGoal1": 120.0,
                    "CarGoal2": 200.0,
                    "CarPush1": 200.0,
                    "CarPush2": 250.0,
                    "PointButton1": 200.0,
                    "PointButton2": 250.0,
                    "PointCircle1": 200.0,
                    "PointCircle2": 299.0,
                    "PointGoal1": 100.0,
                    "PointGoal2": 200.0,
                    "PointPush1": 150.0,
                    "PointPush2": 200.0,
                    "AntVelocity": 250.0,
                    "HalfCheetahVelocity": 250.0,
                    "HopperVelocity": 250.0,
                    "SwimmerVelocity": 200.0,
                    "Walker2dVelocity": 300.0,
                    "AntVelocity_V0": 250.0,
                    "AntCircle_V1": 250,
                    "HalfCheetahVelocity_V0": 300.0,
                    "HopperVelocity_V0": 250.0,
                    "SwimmerVelocity_V0": 200.0,
                    "Walker2dVelocity_V0": 300.0,
                    "AntVelocity_V2": 250.0,
                    "AntVelocity_V3": 250.0,
                    "AntVelocity_V4": 250.0,
                    "AntVelocity_V5": 250.0,
                    "AntVelocity_V6": 250.0,
                    "AntVelocity_V7": 250.0,
                    "HalfCheetahVelocity_V2": 250.0,
                    "HopperVelocity_V2": 250.0,
                    "HopperVelocity_V3": 250.0,
                    "HopperVelocity_V4": 250.0,
                    "HopperVelocity_V5": 250.0,
                    "HopperVelocity_V6": 250.0,
                    "HopperVelocity_V7": 250.0,
                    "SwimmerVelocity_V2": 200.0,
                    "Walker2dVelocity_V2": 300.0,
                    # safe_metadrive
                    "easysparse": 82.42418670654297,
                    "easymean": 82.38601684570312,
                    "easydense": 80.36358642578125,
                    "mediumsparse": 46.46459197998047,
                    "mediummean": 46.46154022216797,
                    "mediumdense": 46.45858383178711,
                    "hardsparse": 85.010009765625,
                    "hardmean": 84.33995056152344,
                    "harddense": 84.76679229736328}

MIN_EPISODE_COST = {# bullet_safety_gym
                    "AntCircle": 0.0,
                    "AntRun": 0.0, 
                    "BallCircle": 0.0,
                    "BallRun": 0.0,
                    "CarCircle": 0.0, 
                    "CarRun": 0.0, 
                    "DroneCircle": 0.0, 
                    "DroneRun": 0.0,
                    # safety_gymnasium
                    "CarButton1": 0.0,
                    "CarButton2": 0.0,
                    "CarCircle1": 0.0,
                    "CarCircle2": 0.0,
                    "CarGoal1": 0.0,
                    "CarGoal2": 0.0,
                    "CarPush1": 0.0,
                    "CarPush2": 0.0,
                    "PointButton1": 0.0,
                    "PointButton2": 0.0,
                    "PointCircle1": 0.0,
                    "PointCircle2": 0.0,
                    "PointGoal1": 0.0,
                    "PointGoal2": 0.0,
                    "PointPush1": 0.0,
                    "PointPush2": 0.0,
                    "AntVelocity": 0.0,
                    "HalfCheetahVelocity": 0.0,
                    "HopperVelocity": 0.0,
                    "SwimmerVelocity": 0.0,
                    "Walker2dVelocity": 0.0,
                    "AntVelocity_V0": 0.0,
                    "AntCircle_V1": 0.0,
                    "HalfCheetahVelocity_V0": 0.0,
                    "HopperVelocity_V0": 0.0,
                    "SwimmerVelocity_V0": 0.0,
                    "Walker2dVelocity_V0": 0.0,
                    "AntVelocity_V2": 0.0,
                    "AntVelocity_V3": 0.0,
                    "AntVelocity_V4": 0.0,
                    "AntVelocity_V5": 0.0,
                    "AntVelocity_V6": 0.0,
                    "AntVelocity_V7": 0.0,
                    "HalfCheetahVelocity_V2": 0.0,
                    "HopperVelocity_V2": 0.0,
                    "HopperVelocity_V3": 0.0,
                    "HopperVelocity_V4": 0.0,
                    "HopperVelocity_V5": 0.0,
                    "HopperVelocity_V6": 0.0,
                    "HopperVelocity_V7": 0.0,
                    "SwimmerVelocity_V2": 0.0,
                    "Walker2dVelocity_V2": 0.0,
                    # safe_metadrive
                    "easysparse": 0.00025356505648232996,
                    "easymean": 0.0,
                    "easydense": 0.0,
                    "mediumsparse": 0.0,
                    "mediummean": 0.0,
                    "mediumdense": 0.0,
                    "hardsparse": 0.0,
                    "hardmean": 0.00033149970113299787,
                    "harddense": 0.0}

DENSITY_CFG = {# bullet_safety_gym
               "OfflineCarCircle-v0_density0.5": {"cbins": 10,
                                                  "rbins": 50,
                                                  "max_npb": 5,
                                                  "min_npb": 2},
               "OfflineCarCircle-v0_density0.75": {"cbins": 10,
                                                  "rbins": 50,
                                                  "max_npb": 9,
                                                  "min_npb": 2},

               "OfflineAntCircle-v0_density0.5": {"cbins": 10,
                                                  "rbins": 50,
                                                  "max_npb": 12,
                                                  "min_npb": 2},
               "OfflineAntCircle-v0_density0.75": {"cbins": 10,
                                                  "rbins": 50,
                                                  "max_npb": 20,
                                                  "min_npb": 2},

               "OfflineAntRun-v0_density0.5": {"cbins": 10,
                                                "rbins": 50,
                                                "max_npb": 6,
                                                "min_npb": 2},
               "OfflineAntRun-v0_density0.75": {"cbins": 10,
                                                "rbins": 50,
                                                "max_npb": 10,
                                                "min_npb": 2},

               "OfflineDroneCircle-v0_density0.5": {"cbins": 10,
                                                    "rbins": 50,
                                                    "max_npb": 10,
                                                    "min_npb": 2},
               "OfflineDroneCircle-v0_density0.75": {"cbins": 10,
                                                    "rbins": 50,
                                                    "max_npb": 18,
                                                    "min_npb": 2},
                                                    
               "OfflineDroneRun-v0_density0.5": {"cbins": 10,
                                                 "rbins": 50,
                                                 "max_npb": 6,
                                                 "min_npb": 2},
               "OfflineDroneRun-v0_density0.75": {"cbins": 10,
                                                  "rbins": 50,
                                                  "max_npb": 18,
                                                  "min_npb": 2},

               "OfflineBallCircle-v0_density0.5": {"cbins": 10,
                                                 "rbins": 20,
                                                 "max_npb": 5,
                                                 "min_npb": 2},
               "OfflineBallCircle-v0_density0.75": {"cbins": 10,
                                                  "rbins": 30,
                                                  "max_npb": 10,
                                                  "min_npb": 2},

               "OfflineBallRun-v0_density0.5": {"cbins": 10,
                                                 "rbins": 15,
                                                 "max_npb": 7,
                                                 "min_npb": 2},
               "OfflineBallRun-v0_density0.75": {"cbins": 10,
                                                  "rbins": 15,
                                                  "max_npb": 12,
                                                  "min_npb": 2},

               "OfflineCarRun-v0_density0.5": {"cbins": 10,
                                                 "rbins": 20,
                                                 "max_npb": 6,
                                                 "min_npb": 2},
               "OfflineCarRun-v0_density0.75": {"cbins": 10,
                                                  "rbins": 20,
                                                  "max_npb": 11,
                                                  "min_npb": 2},
               # safety_gymnasium                                    
               "OfflineCarButton1Gymnasium-v0_density0.5": {"cbins": 10,
                                                            "rbins": 10,
                                                            "max_npb": 18,
                                                            "min_npb": 2},
               "OfflineCarButton1Gymnasium-v0_density0.25": {"cbins": 10,
                                                             "rbins": 10,
                                                             "max_npb": 8,
                                                             "min_npb": 2},
                                                  
               "OfflineCarButton2Gymnasium-v0_density0.5": {"cbins": 10,
                                                            "rbins": 8,
                                                            "max_npb": 28,
                                                            "min_npb": 2},
               "OfflineCarButton2Gymnasium-v0_density0.25": {"cbins": 10,
                                                             "rbins": 8,
                                                             "max_npb": 13,
                                                             "min_npb": 2},
                                                  
               "OfflineCarCircle1Gymnasium-v0_density0.5": {"cbins": 10,
                                                            "rbins": 5,
                                                            "max_npb": 28,
                                                            "min_npb": 2},
               "OfflineCarCircle1Gymnasium-v0_density0.25": {"cbins": 10,
                                                             "rbins": 5,
                                                             "max_npb": 12,
                                                             "min_npb": 2},
                                                  
               "OfflineCarCircle2Gymnasium-v0_density0.5": {"cbins": 10,
                                                            "rbins": 5,
                                                            "max_npb": 18,
                                                            "min_npb": 2},
               "OfflineCarCircle2Gymnasium-v0_density0.25": {"cbins": 10,
                                                             "rbins": 5,
                                                             "max_npb": 8,
                                                             "min_npb": 2},
               
               "OfflineCarGoal1Gymnasium-v0_density0.5": {"cbins": 10,
                                                          "rbins": 8,
                                                          "max_npb": 13,
                                                          "min_npb": 2},
               "OfflineCarGoal1Gymnasium-v0_density0.25": {"cbins": 10,
                                                           "rbins": 8,
                                                           "max_npb": 6,
                                                           "min_npb": 2},
                                                           
               "OfflineCarGoal2Gymnasium-v0_density0.5": {"cbins": 10,
                                                          "rbins": 8,
                                                          "max_npb": 30,
                                                          "min_npb": 2},
               "OfflineCarGoal2Gymnasium-v0_density0.25": {"cbins": 10,
                                                           "rbins": 8,
                                                           "max_npb": 14,
                                                           "min_npb": 2},
                                                           
               "OfflineCarPush1Gymnasium-v0_density0.5": {"cbins": 10,
                                                          "rbins": 6,
                                                          "max_npb": 36,
                                                          "min_npb": 2},
               "OfflineCarPush1Gymnasium-v0_density0.25": {"cbins": 10,
                                                           "rbins": 6,
                                                           "max_npb": 16,
                                                           "min_npb": 2},
                                                           
               "OfflineCarPush2Gymnasium-v0_density0.5": {"cbins": 10,
                                                          "rbins": 8,
                                                          "max_npb": 50,
                                                          "min_npb": 2},
               "OfflineCarPush2Gymnasium-v0_density0.25": {"cbins": 10,
                                                           "rbins": 8,
                                                           "max_npb": 22,
                                                           "min_npb": 2},
                                                           
               "OfflinePointButton1Gymnasium-v0_density0.5": {"cbins": 10,
                                                              "rbins": 10,
                                                              "max_npb": 13,
                                                              "min_npb": 2},
               "OfflinePointButton1Gymnasium-v0_density0.25": {"cbins": 10,
                                                               "rbins": 10,
                                                               "max_npb": 6,
                                                               "min_npb": 2},
                                                               
               "OfflinePointButton2Gymnasium-v0_density0.5": {"cbins": 10,
                                                            "rbins": 8,
                                                            "max_npb": 25,
                                                            "min_npb": 2},
               "OfflinePointButton2Gymnasium-v0_density0.25": {"cbins": 10,
                                                             "rbins": 8,
                                                             "max_npb": 12,
                                                             "min_npb": 2},
                                                             
               "OfflinePointCircle1Gymnasium-v0_density0.5": {"cbins": 10,
                                                              "rbins": 5,
                                                              "max_npb": 28,
                                                              "min_npb": 2},
               "OfflinePointCircle1Gymnasium-v0_density0.25": {"cbins": 10,
                                                               "rbins": 5,
                                                               "max_npb": 12,
                                                               "min_npb": 2},
                                                               
               "OfflinePointCircle2Gymnasium-v0_density0.5": {"cbins": 10,
                                                            "rbins": 5,
                                                            "max_npb": 20,
                                                            "min_npb": 2},
               "OfflinePointCircle2Gymnasium-v0_density0.25": {"cbins": 10,
                                                             "rbins": 5,
                                                             "max_npb": 10,
                                                             "min_npb": 2},
                                                             
               "OfflinePointGoal1Gymnasium-v0_density0.5": {"cbins": 10,
                                                            "rbins": 8,
                                                            "max_npb": 16,
                                                            "min_npb": 2},
               "OfflinePointGoal1Gymnasium-v0_density0.25": {"cbins": 10,
                                                             "rbins": 8,
                                                             "max_npb": 7,
                                                             "min_npb": 2},
                                                             
               "OfflinePointGoal2Gymnasium-v0_density0.5": {"cbins": 10,
                                                          "rbins": 8,
                                                          "max_npb": 24,
                                                          "min_npb": 2},
               "OfflinePointGoal2Gymnasium-v0_density0.25": {"cbins": 10,
                                                           "rbins": 6,
                                                           "max_npb": 14,
                                                           "min_npb": 2},
                                                           
               "OfflinePointPush1Gymnasium-v0_density0.5": {"cbins": 10,
                                                          "rbins": 6,
                                                          "max_npb": 28,
                                                          "min_npb": 2},
               "OfflinePointPush1Gymnasium-v0_density0.25": {"cbins": 10,
                                                           "rbins": 6,
                                                           "max_npb": 13,
                                                           "min_npb": 2},
                                                           
               "OfflinePointPush2Gymnasium-v0_density0.5": {"cbins": 10,
                                                          "rbins": 8,
                                                          "max_npb": 34,
                                                          "min_npb": 2},
               "OfflinePointPush2Gymnasium-v0_density0.25": {"cbins": 10,
                                                           "rbins": 8,
                                                           "max_npb": 15,
                                                           "min_npb": 2},
                                                           
               "OfflineHalfCheetahVelocityGymnasium-v1_density0.25": {"cbins": 10,
                                                           "rbins": 10,
                                                           "max_npb": 12,
                                                           "min_npb": 2},
               "OfflineHalfCheetahVelocityGymnasium-v1_density0.5": {"cbins": 10,
                                                           "rbins": 10,
                                                           "max_npb": 26,
                                                           "min_npb": 2},
                                                           
               "OfflineSwimmerVelocityGymnasium-v1_density0.25": {"cbins": 10,
                                                           "rbins": 10,
                                                           "max_npb": 7,
                                                           "min_npb": 2},
               "OfflineSwimmerVelocityGymnasium-v1_density0.5": {"cbins": 10,
                                                           "rbins": 10,
                                                           "max_npb": 14,
                                                           "min_npb": 2},
                                                           
               "OfflineWalker2dVelocityGymnasium-v1_density0.25": {"cbins": 10,
                                                           "rbins": 10,
                                                           "max_npb": 10,
                                                           "min_npb": 2},
               "OfflineWalker2dVelocityGymnasium-v1_density0.5": {"cbins": 10,
                                                           "rbins": 10,
                                                           "max_npb": 22,
                                                           "min_npb": 2},
                                                           
               "OfflineMetadrive-easydense-v0_density0.5": {"cbins": 10,
                                                           "rbins": 20,
                                                           "max_npb": 15,
                                                           "min_npb": 2},
               "OfflineMetadrive-easydense-v0_density0.75": {"cbins": 10,
                                                           "rbins": 20,
                                                           "max_npb": 30,
                                                           "min_npb": 2},
                                                           
               "OfflineMetadrive-mediummean-v0_density0.5": {"cbins": 10,
                                                           "rbins": 20,
                                                           "max_npb": 16,
                                                           "min_npb": 2},
               "OfflineMetadrive-mediummean-v0_density0.75": {"cbins": 10,
                                                           "rbins": 20,
                                                           "max_npb": 33,
                                                           "min_npb": 2},
                                                           
               "OfflineMetadrive-hardsparse-v0_density0.5": {"cbins": 10,
                                                           "rbins": 20,
                                                           "max_npb": 12,
                                                           "min_npb": 2},
               "OfflineMetadrive-hardsparse-v0_density0.75": {"cbins": 10,
                                                           "rbins": 20,
                                                           "max_npb": 32,
                                                           "min_npb": 2},}
